<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$db = new SQLite3('./api/.db.db');

// Crear la tabla ibo si no existe
$db->exec('CREATE TABLE IF NOT EXISTS ibo(id INTEGER PRIMARY KEY NOT NULL, mac_address VARCHAR(100), username VARCHAR(100), password VARCHAR(100), expire_date VARCHAR(100), url VARCHAR(100), title VARCHAR(100), created_at VARCHAR(100))');

// Crear la tabla subscription si no existe
$db->exec("CREATE TABLE IF NOT EXISTS subscription(id INTEGER PRIMARY KEY, mac_address TEXT, expire_date TEXT)");

if (isset($_GET['index'])) {
    $index = $_GET['index'];
} else {
    $index = "";
}

// Obtener las opciones de DNS
$dnsOptions = [];
$dnsResult = $db->query('SELECT * FROM dns');
while ($row = $dnsResult->fetchArray(SQLITE3_ASSOC)) {
    $dnsOptions[] = $row;
}

if (isset($_POST['submit'])) {
    $we = strtotime($_POST['expire_date']);
    $ne = date('Y-m-d', $we);
    $start = date('Y-m-d');
    $end = date('H:i:s');
    $full = $start . 'T' . $end . '.000000Z';

    $macAddresses = $_POST['mac_address'];
    $isSuccess = true;  // Variable para manejar si todo ha ido bien

    foreach ($macAddresses as $mac) {
        $formattedMac = strtoupper($mac);

        // Insertar en la tabla ibo
        $iboQuery = "INSERT INTO ibo(mac_address, username, password, expire_date, url, title, created_at)
                     VALUES('$formattedMac', '{$_POST['username']}', '{$_POST['password']}', '$ne', '{$_POST['dns']}', '{$_POST['title']}', '$full')";
        if (!$db->exec($iboQuery)) {
            $isSuccess = false;  // Si algo sale mal, cambiamos el estado a falso
        }

        // Insertar en la tabla subscription solo si no existe
        $checkQuery = "SELECT COUNT(*) as count FROM subscription WHERE mac_address = :macAddress";
        $stmt = $db->prepare($checkQuery);
        $stmt->bindValue(':macAddress', $formattedMac, SQLITE3_TEXT);
        $result = $stmt->execute();
        $row = $result->fetchArray(SQLITE3_ASSOC);

        if ($row['count'] == 0) {
            $insertQuery = "INSERT INTO subscription (mac_address, expire_date) VALUES (:macAddress, :expireDate)";
            $stmt = $db->prepare($insertQuery);
            $stmt->bindValue(':macAddress', $formattedMac, SQLITE3_TEXT);
            $stmt->bindValue(':expireDate', $ne, SQLITE3_TEXT);
            if (!$stmt->execute()) {
                $isSuccess = false;  // Si la inserción en subscription falla, cambiamos el estado
            }
        }
    }

    // Si todo fue exitoso
    if ($isSuccess) {
        echo '<script>alert("Cliente(s) y suscripción(s) registradas correctamente.");</script>';
        header('Location: users.php');
        exit;
    } else {
        echo '<script>alert("Hubo un error al registrar los datos. Intente nuevamente.");</script>';
    }

    // Cerrar la base de datos después de todas las operaciones
    $db->close();
}

include 'includes/header.php';
?>

<script>
document.addEventListener("DOMContentLoaded", function() {
    function formatMacInput(input) {
        input.addEventListener("input", function(e) {
            var value = e.target.value.replace(/[^a-fA-F0-9]/g, "").toUpperCase();
            var formatted = "";
            for (var i = 0; i < value.length; i++) {
                formatted += value[i];
                if ((i + 1) % 2 === 0 && i < value.length - 1) {
                    formatted += ":";
                }
            }
            e.target.value = formatted;
        });
    }

    formatMacInput(document.querySelector('.mac-input'));

    document.getElementById('add_mac_field').addEventListener('click', function () {
        var container = document.getElementById('mac_fields');
        var newInputGroup = document.createElement('div');
        newInputGroup.classList.add('input-group', 'mt-2');
        newInputGroup.innerHTML = `<input class="form-control text-primary mac-input" name="mac_address[]" type="text" placeholder="Enter MAC Address" required/>`;
        container.appendChild(newInputGroup);
        formatMacInput(newInputGroup.querySelector('.mac-input'));
    });
});
</script>

<script>
function getParameterByName(name, url) {
  name = name.replace(/[\[\]]/g, "\\$&");
  var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
      results = regex.exec(url);
  if (!results) return "";
  if (!results[2]) return "";
  return decodeURIComponent(results[2].replace(/\+/g, " "));
}
</script>

<div class="container-fluid">
    <div class="mx-auto" style="max-width: 900px;">
        <h1 class="title-outside-card mb-1">Registrar Clientes</h1>
        <div class="card border-left-primary shadow h-100 card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-color"><i class="fas fa-user"></i>Detalles</h6>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label><strong>Mac Address</strong></label>
                        <div id="mac_fields">
                            <div class="input-group">
                                <input class="form-control text-primary mac-input" name="mac_address[]" type="text" placeholder="Enter MAC Address" value="<?php echo strtoupper($index); ?>" required/>
                            </div>
                        </div>
                        <button type="button" id="add_mac_field" class="btn btn-secondary mt-2">Agregar otra MAC</button>
                    </div>
                    <div class="form-group">
                        <label>Usuario</label>
                        <input type="text" name="username" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Contraseña</label>
                        <input type="text" name="password" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>DNS</label>
                        <select name="dns" class="form-control" required>
                            <option value="">Seleccionar DNS</option>
                            <?php foreach ($dnsOptions as $dns): ?>
                                <option value="<?= htmlspecialchars($dns['url']) ?>"><?= htmlspecialchars($dns['url']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Nombre del Servidor o del Cliente</label>
                        <input type="text" name="title" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Fecha de Expiración</label>
                        <input type="date" name="expire_date" class="form-control" required>
                    </div>

                    <button type="submit" name="submit" class="btn btn-success btn-icon-split">
                        <span class="icon text-white-50"><i class="fas fa-check"></i></span>
                        <span class="text">Guardar</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
$('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>

</body>
<?php include 'includes/footer.php'; ?>
</html>
