<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Connect to the SQLite database
$db = new SQLite3('./api/.db.db');

// Retrieve user data based on the 'update' parameter from the URL
$updateId = $_GET['update'];

// Fetch data from the 'ibo' table
$res = $db->query('SELECT * FROM ibo WHERE id=\'' . $updateId . '\'');
$row = $res->fetchArray();

$id = $row['id'];
$mac_address = $row['mac_address'];
$expire_date = $row['expire_date'];
$username = $row['username'];
$password = $row['password'];
$url = $row['url'];
$title = $row['title'];

// Check if the form has been submitted
if (isset($_POST['submit'])) {
    // Format the expiration date
    $we = strtotime($_POST['expire_date']);
    $ne = date('Y-m-d', $we);
    $start = date('Y-m-d');
    $end = date('h:m:s');
    $full = $start . 'T' . $end . '.000000Z';

    // Update the 'ibo' table with the new data
    $db->exec('UPDATE ibo SET 
        mac_address=\'' . $_POST['mac_address'] . '\',
        expire_date=\'' . $ne . '\',
        username=\'' . $_POST['username'] . '\',
        url=\'' . $_POST['url'] . '\',
        title=\'' . $_POST['title'] . '\',
        password=\'' . $_POST['password'] . '\',
        created_at=\'' . $full . '\'
        WHERE id=\'' . $_POST['id'] . '\''
    );

    // Update the 'subscription' table with the same MAC address and expiration date
    $expireDateTimestamp = strtotime($_POST['expire_date']);
    $formattedExpireDate = date('Y-m-d', $expireDateTimestamp);

    // Update subscription table to reflect the new mac_address and expire_date
    $updateQuery = 'UPDATE subscription SET 
        mac_address=:mac_address, 
        expire_date=:expire_date 
        WHERE mac_address=:mac_address';
    $updateStmt = $db->prepare($updateQuery);
    $updateStmt->bindValue(':mac_address', $_POST['mac_address'], SQLITE3_TEXT);
    $updateStmt->bindValue(':expire_date', $formattedExpireDate, SQLITE3_TEXT);
    $updateStmt->execute();

    // Close the database connection and redirect
    $db->close();
    header('Location: buscar_users.php?updated=1');
exit;
}
// Store user data in variables for use in the HTML form
$userUpdateId = $row['id'];
$userUpdateMacAddress = $row['mac_address'];
$userUpdateExpireDate = $row['expire_date'];
$userUpdateUsername = $row['username'];
$userUpdatePassword = $row['password'];
$userUpdateUrl = $row['url'];
$userUpdateTitle = $row['title'];

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Generar Código de Activación</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/4fa1f3b6b2.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="css/rgvip.css">
<script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
    <style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        padding: 20px;
        background: linear-gradient(to right, #0f2027, #203a43, #2c5364);
        color: #f0f0f0;
        min-height: 100vh;
    }

    .container {
        max-width: 400px;
        margin: auto;
        background: #1e1e2f;
        padding: 30px 25px;
        border-radius: 14px;
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.4);
        position: relative;
        z-index: 2;
    }
.card-body {
    background-color: #1e1e2f; /* Fondo oscuro */
    padding: 20px; /* Espaciado interno */
    border-radius: 10px; /* Bordes redondeados */
    color: #fff; /* Color de texto blanco */
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* Sombra sutil */
}

.card-body h2, .card-body h6 {
    color: #fff; /* Colores de los encabezados en blanco */
}

.card-body a {
    color: #0A38D1; /* Color para enlaces */
}

.card-body a:hover {
    color: #1e3c72; /* Cambio de color al pasar el ratón */
}

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #ffffff;
        font-weight: 600;
    }

    input, select, button {
        width: 100%;
        padding: 14px;
        margin-bottom: 18px;
        border-radius: 8px;
        border: 1px solid #444;
        background-color: #2a2a3d;
        color: #fff;
        font-size: 15px;
        transition: all 0.3s ease;
    }

    input:focus, select:focus {
        outline: none;
        border-color: #00c851;
        box-shadow: 0 0 6px rgba(0, 200, 81, 0.4);
        background-color: #32324a;
    }

    button {
        background-color: #00c851;
        color: white;
        font-weight: bold;
        font-size: 16px;
        border: none;
        transition: background-color 0.3s ease;
    }

    button:hover {
        background-color: #007e33;
    }

    .alert {
        background-color: #1c352d;
        color: #28a745;
        padding: 12px;
        border-radius: 6px;
        margin-top: 10px;
        border-left: 4px solid #28a745;
        display: none;
    }

    .alert.error {
        background-color: #3b1f1f;
        color: #e74c3c;
        border-left-color: #e74c3c;
    }

    pre {
        background: #2c2c3c;
        padding: 12px;
        border-radius: 6px;
        color: #ddd;
        font-family: 'Courier New', monospace;
        font-size: 14px;
        overflow-x: auto;
    }

    /* Modal */
    .modal {
        display: none;
        position: fixed;
        z-index: 999;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.6);
        padding-top: 60px;
    }

    .modal-content {
    background-color: #1e1e2f;
    margin: 5% auto;
    padding: 20px;
    border: 1px solid #444;
    width: 90%; /* se adapta mejor en móviles */
    max-width: 600px; /* ancho máximo en pantallas grandes */
    border-radius: 10px;
    text-align: center;
    color: #f0f0f0;
    box-sizing: border-box;
}

/* Opcional: hacer el texto del <pre> más adaptable */
.modal-content pre {
    font-size: 14px;
    color: #ccc;
    word-wrap: break-word;
    white-space: pre-wrap;
}

    .modal-header, .modal-footer {
        padding: 10px 0;
        border-bottom: 1px solid #444;
    }

    .modal-footer {
        border-top: 1px solid #444;
    }

    .btn-modal {
        padding: 10px 20px;
        margin: 5px;
        border-radius: 5px;
        cursor: pointer;
        border: none;
        transition: background-color 0.3s ease;
    }

    .btn-modal.copy { background-color: #007bff; color: white; }
    .btn-modal.copy:hover { background-color: #0056b3; }

    .btn-modal.whatsapp { background-color: #25d366; color: white; }
    .btn-modal.whatsapp:hover { background-color: #128c7e; }

    .btn-modal.activate { background-color: #17a2b8; color: white; }
    .btn-modal.activate:hover { background-color: #117a8b; }

    .btn-modal.close { background-color: #dc3545; color: white; }
    .btn-modal.close:hover { background-color: #c82333; }
</style>
</head>
<body>
<!-- Display the form with user data -->
<div class="container-fluid">
    <div class="mx-auto" style="max-width: 500px;">
        <h1 class="title-outside-card mb-1">Actualizar Cliente</h1>
        <div class="card border-left-primary shadow h-100 card shadow mb-4">
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <label class="control-label" for="mac_address"><strong>Mac Address</strong></label>
                        <div class="input-group">
                            <input type="hidden" name="id" value="<?= $id ?>" />
                            <input class="form-control text-primary" id="description" name="mac_address" value="<?= $mac_address ?>" type="text" required />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="username"><strong>Usuario</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="username" value="<?= $username ?>" id="description" required />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="password"><strong>Contraseña</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="password" value="<?= $password ?>" id="description" required />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="expire_date"><strong>Fecha de Expiración</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="expire_date" value="<?= $expire_date ?>" id="datepicker" />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="url"><strong>URL</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="url" value="<?= $url ?>" id="description" required />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label" for="title"><strong>Nombre del Cliente</strong></label>
                        <div class="input-group">
                            <input type="text" class="form-control text-primary" name="title" value="<?= $title ?>" id="description" required />
                        </div>
                    </div>
                    <div class="form-group">
                        <div>
                            <button class="btn btn-success btn-icon-split" name="submit" type="submit">
                                <span class="icon text-white-50"><i class="fa fa-check"></i></span><span class="text">Guardar</span>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>