<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() === PHP_SESSION_NONE) {
	session_start();
}

//parse config options
$config_ini = parse_ini_file("./config.ini");

if ($config_ini['debug'] == 1 ){
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
}else{
	ini_set('display_errors', 0);
}

//db call
$db = new SQLite3('./api/.db.db');
$adb = new SQLite3('./api/.adb.db');
//user check
$log_check = $db->query("SELECT * FROM users WHERE id='1'");
$roe = $log_check->fetchArray();
$loggedinuser = @$roe['username'];
//login check

if (!isset($_SESSION['name']) == $loggedinuser) {
	header("location:"."index.php");
	exit();
}
//logout due to session time
$time = $_SERVER['REQUEST_TIME'];

$timeout_duration = 900;
if (isset($_SESSION['LAST_ACTIVITY']) && 
	($time - $_SESSION['LAST_ACTIVITY']) > $timeout_duration) {
	session_unset();
	session_destroy();
	session_start();
}
$_SESSION['LAST_ACTIVITY'] = $time;

//sanitize strings
function sanitize($data) {
	$data = trim($data);
	$data = htmlspecialchars($data, ENT_QUOTES );
	$data = SQLite3::escapeString($data);
	return $data;
}
//current file var
$base_file = basename($_SERVER["SCRIPT_NAME"]);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <meta name="author" content="RGVIP PANELS" />

  <!-- Bootstrap y librerías -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css" />
  <link rel="stylesheet" href="css/rgvip.css" />
	<link href="css/simple-sidebar.css" rel="stylesheet">
  <!-- Partículas -->
  <script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
</head>
<style>
  .modal-body .list-group-item {
    color: #000 !important;
  }
  .modal-body .list-group-item i {
    color: #000 !important;
  }
</style>
<body>

<div id="particles-js"></div>

<div class="d-flex" id="wrapper">
  <div class="sidebar-overlay" id="sidebarOverlay"></div>

  <div id="sidebar-wrapper">
    <div class="sidebar-heading">Rgvip Panels</div>
    <span>
      <a class="list-group-item" href="https://apps-rgvip.com" target="_blank">
        &nbsp;&nbsp;&nbsp;&nbsp;&#169; <?=date("Y")?> * IBO 4k Rgvip *
      </a>
    </span>
    <div class="list-group list-group-flush">
    <a class="list-group-item list-group-item-action" href="dns.php">
        <i class="fa fa-globe"></i>&nbsp;&nbsp; Registrar DNS
    </a>
    <a class="list-group-item list-group-item-action" href="migrar_dns.php">
        <i class="fa fa-server"></i>&nbsp;&nbsp; Migrar dns Masivo
    </a>
    <a class="list-group-item list-group-item-action" href="users.php">
        <i class="fa fa-users"></i>&nbsp;&nbsp; Usuarios MAC
    </a>
    <a class="list-group-item list-group-item-action" href="mRTXSubscription.php">
        <i class="fa fa-calendar"></i>&nbsp;&nbsp; Ajustar alerta de Vencimientos
    </a>
    <a class="list-group-item list-group-item-action" href="mRTXTrial.php">
        <i class="fa fa-desktop"></i>&nbsp;&nbsp; Cuenta Demo
    </a>
    <a class="list-group-item list-group-item-action" href="#" data-toggle="modal" data-target="#modalPersonalizar">
    <i class="fa fa-paint-brush"></i>&nbsp;&nbsp; Personalizar
    </a>
    <a class="list-group-item list-group-item-action" href="generar_codigo.php">
    <i class="fa fa-key"></i>&nbsp;&nbsp; Generar Códigos
    </a>
    <a class="list-group-item list-group-item-action" href="activar.php">
    <i class="fa fa-check-circle"></i>&nbsp;&nbsp; Activar Códigos
    </a>
    <a class="list-group-item list-group-item-action" href="gestionar_codigos.php">
    <i class="fa fa-cogs"></i>&nbsp;&nbsp; Gestionar Códigos
    </a>
    <a class="list-group-item list-group-item-action" href="buscar_users.php">
    <i class="fa fa-share-alt"></i>&nbsp;&nbsp; Link Reseller
    </a>
    <a class="list-group-item list-group-item-action" href="activar_publico.php">
    <i class="fa fa-share-alt"></i>&nbsp;&nbsp; Link Clientes
    </a>
    <!--<a class="list-group-item list-group-item-action" href="mRTXSport.php">
        <i class="fa fa-futbol-o"></i>&nbsp;&nbsp; Lista de Deportes
    </a>-->
    <a class="list-group-item list-group-item-action" href="user.php">
        <i class="fa fa-user"></i>&nbsp;&nbsp; Actualizar Credenciales
    </a>
    <div style="height: 60px;"></div>
</div>
</div>
  <div id="page-content-wrapper">
    <nav class="navbar navbar-expand-lg navbar-dark">
      <button class="btn btn-primary" id="menuToggle">
        <img src="img/logo.png?ts=<?= time(); ?>" width="25" height="25" class="d-flex justify-content-center text-align centre" alt="">
      </button>
      &nbsp;&nbsp;
      <div class="center" id="pageMessages"></div>
      <a href="logout.php" class="btn btn-danger ml-auto mr-1">Salir</a>
    </nav>

    <div class="container-fluid"><br>
    <!-- Modal -->
<div class="modal fade" id="modalPersonalizar" tabindex="-1" role="dialog" aria-labelledby="modalPersonalizarLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalPersonalizarLabel">Opciones de Personalización</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body list-group">
        <a class="list-group-item list-group-item-action" href="mRTXMessage.php" style="color: #000;">
            <i class="fa fa-commenting" style="color: #000;"></i>&nbsp;&nbsp; Texto en Playlists
        </a>
        <a class="list-group-item list-group-item-action" href="mRTXlogo.php" style="color: #000;">
            <i class="fa fa-image" style="color: #000;"></i>&nbsp;&nbsp; Cambiar Logo
        </a>
        <a class="list-group-item list-group-item-action" href="mRTXBG.php" style="color: #000;">
            <i class="fa fa-picture-o" style="color: #000;"></i>&nbsp;&nbsp; Cambiar Fondo
        </a>
      </div>
    </div>
  </div>
</div>
<script src="js/panelrgvip.js"></script>
</body>
</html>
