<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Generar Código de Activación</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/4fa1f3b6b2.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="css/rgvip.css">
<script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
    <style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        padding: 20px;
        background: linear-gradient(to right, #0f2027, #203a43, #2c5364);
        color: #f0f0f0;
        min-height: 100vh;
    }

    .container {
        max-width: 500px;
        margin: auto;
        background: #1e1e2f;
        padding: 30px 25px;
        border-radius: 14px;
        box-shadow: 0 15px 40px rgba(0, 0, 0, 0.4);
        position: relative;
        z-index: 2;
    }

    h2 {
        text-align: center;
        margin-bottom: 25px;
        color: #ffffff;
        font-weight: 600;
    }

    input, select, button {
        width: 100%;
        padding: 14px;
        margin-bottom: 18px;
        border-radius: 8px;
        border: 1px solid #444;
        background-color: #2a2a3d;
        color: #fff;
        font-size: 15px;
        transition: all 0.3s ease;
    }

    input:focus, select:focus {
        outline: none;
        border-color: #00c851;
        box-shadow: 0 0 6px rgba(0, 200, 81, 0.4);
        background-color: #32324a;
    }

    button {
        background-color: #00c851;
        color: white;
        font-weight: bold;
        font-size: 16px;
        border: none;
        transition: background-color 0.3s ease;
    }

    button:hover {
        background-color: #007e33;
    }

    .alert {
        background-color: #1c352d;
        color: #28a745;
        padding: 12px;
        border-radius: 6px;
        margin-top: 10px;
        border-left: 4px solid #28a745;
        display: none;
    }

    .alert.error {
        background-color: #3b1f1f;
        color: #e74c3c;
        border-left-color: #e74c3c;
    }

    pre {
        background: #2c2c3c;
        padding: 12px;
        border-radius: 6px;
        color: #ddd;
        font-family: 'Courier New', monospace;
        font-size: 14px;
        overflow-x: auto;
    }

    /* Modal */
    .modal {
        display: none;
        position: fixed;
        z-index: 999;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.6);
        padding-top: 60px;
    }

    .modal-content {
    background-color: #1e1e2f;
    margin: 5% auto;
    padding: 20px;
    border: 1px solid #444;
    width: 90%; /* se adapta mejor en móviles */
    max-width: 600px; /* ancho máximo en pantallas grandes */
    border-radius: 10px;
    text-align: center;
    color: #f0f0f0;
    box-sizing: border-box;
}

/* Opcional: hacer el texto del <pre> más adaptable */
.modal-content pre {
    font-size: 14px;
    color: #ccc;
    word-wrap: break-word;
    white-space: pre-wrap;
}

    .modal-header, .modal-footer {
        padding: 10px 0;
        border-bottom: 1px solid #444;
    }

    .modal-footer {
        border-top: 1px solid #444;
    }

    .btn-modal {
        padding: 10px 20px;
        margin: 5px;
        border-radius: 5px;
        cursor: pointer;
        border: none;
        transition: background-color 0.3s ease;
    }

    .btn-modal.copy { background-color: #007bff; color: white; }
    .btn-modal.copy:hover { background-color: #0056b3; }

    .btn-modal.whatsapp { background-color: #25d366; color: white; }
    .btn-modal.whatsapp:hover { background-color: #128c7e; }

    .btn-modal.activate { background-color: #17a2b8; color: white; }
    .btn-modal.activate:hover { background-color: #117a8b; }

    .btn-modal.close { background-color: #dc3545; color: white; }
    .btn-modal.close:hover { background-color: #c82333; }
</style>
</head>
<body>
<!-- Fondo de partículas -->
    <div id="particles-js"></div>
<div class="container">
    <h3 class="text-center mb-4">🔑 Generar Código</h3>
    <form id="formCodigo">
        <input type="text" name="mac_address" placeholder="Dirección MAC" class="mac-input" required>
        <input type="text" name="username" placeholder="Usuario" required>
        <input type="text" name="password" placeholder="Contraseña" required>
        <select name="dns" id="dns" required>
            <option value="">Cargando DNS...</option>
        </select>
        <input type="text" name="title" placeholder="Nombre del cliente" required>
        <input type="date" name="expire_date" required>
        <button type="submit">Generar Código</button>
    </form>
    <div class="alert" id="resultado"></div>
</div>
<!-- Modal -->
<div id="modal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Código de Activación Generado</h3>
        </div>
        <div class="modal-body">
            <p><strong>✅ Código:</strong></p>
            <pre id="codigoGenerado"></pre>
            <p><strong>🖥️ MAC:</strong> <span id="macGenerada"></span></p>
        </div>
        <div class="modal-footer">
    <button class="btn-modal copy" id="btnCopy">
        <span>✅ Copiar Código</span>
    </button>
    <button class="btn-modal whatsapp" id="btnWhatsapp">
        <span>📲 Compartir por WhatsApp</span>
    </button>
    <button class="btn-modal activate" id="btnActivate">
        <span>✔️ Activar Cliente</span>
    </button>
    <button class="btn-modal close" id="btnClose">
        <span style="color: white;">❌ Cerrar</span>
    </button>
</div>
    </div>
</div>
<script>
// Cargar opciones DNS dinámicamente desde API
document.addEventListener("DOMContentLoaded", function() {
    const dnsSelect = document.getElementById('dns');
    fetch('api/get_dns.php')
        .then(res => res.json())
        .then(dnsOptions => {
            dnsSelect.innerHTML = '<option value="">Seleccione DNS</option>';
            dnsOptions.forEach(url => {
                dnsSelect.innerHTML += `<option value="${url}">${url}</option>`;
            });
        })
        .catch(err => {
            dnsSelect.innerHTML = '<option value="">Error al cargar DNS</option>';
            console.error('Error cargando DNS:', err);
        });
});

// Enviar formulario por AJAX
document.getElementById('formCodigo').addEventListener('submit', function(e) {
    e.preventDefault();
    const formData = new FormData(this);
    fetch('api/generar_codigo_api.php', {
        method: 'POST',
        body: formData
    })
    .then(resp => resp.json())
    .then(data => {
        if (data.success) {
            document.getElementById('codigoGenerado').textContent = data.codigo;
            document.getElementById('macGenerada').textContent = data.mac;
            document.getElementById('modal').style.display = 'block';
        } else {
            alert('Error: ' + data.error);
        }
    });
});

// Copiar código al portapapeles
document.getElementById('btnCopy').addEventListener('click', function() {
    const codigo = document.getElementById('codigoGenerado').textContent;
    navigator.clipboard.writeText(codigo).then(() => {
        alert('Código copiado al portapapeles');
    });
});

// Compartir por WhatsApp
document.getElementById('btnWhatsapp').addEventListener('click', function() {
    const codigo = document.getElementById('codigoGenerado').textContent;
    const mac = document.getElementById('macGenerada').textContent;
    const protocolo = location.protocol;
    const host = location.host;
    const path = location.pathname.substring(0, location.pathname.lastIndexOf('/'));
    const activarUrl = protocolo + '//' + host + path + '/activar_publico.php';
    const mensaje = `🎉 ¡Código de activación generado! 🎯\n\n🔐 *Código:* ${codigo}\n🖥️ *MAC:* ${mac}\n\n✅ Ve a la página de activación:\n${activarUrl}`;
    const whatsappUrl = `https://wa.me/?text=${encodeURIComponent(mensaje)}`;
    window.open(whatsappUrl, '_blank');
});

// Redirigir al cliente a la página de activación
document.getElementById('btnActivate').addEventListener('click', function() {
    const codigo = document.getElementById('codigoGenerado').textContent;
    const mac = document.getElementById('macGenerada').textContent;
    const protocolo = location.protocol;
    const host = location.host;
    const path = location.pathname.substring(0, location.pathname.lastIndexOf('/'));
    const activarUrl = protocolo + '//' + host + path + '/activar_publico.php?codigo=' + codigo + '&mac=' + mac;
    window.location.href = activarUrl;
});

// Cerrar el modal
document.getElementById('btnClose').addEventListener('click', function() {
    document.getElementById('modal').style.display = 'none';
});

// Script para formatear la dirección MAC en tiempo real
document.addEventListener("DOMContentLoaded", function() {
    const macInput = document.querySelector('.mac-input');
    if (macInput) {
        macInput.addEventListener("input", function(e) {
            let value = e.target.value.replace(/[^a-fA-F0-9]/g, "").toUpperCase();
            let formatted = "";
            for (let i = 0; i < value.length; i++) {
                formatted += value[i];
                if ((i + 1) % 2 === 0 && i < value.length - 1) {
                    formatted += ":";
                }
            }
            e.target.value = formatted;
        });
    }
});
</script>
    <script src="js/panelrgvip.js"></script>
<script>
    document.addEventListener('contextmenu', function(e) {
        if (e.target.tagName === 'INPUT' || e.target.tagName === 'TEXTAREA') {
            return;
        }
        e.preventDefault();
    });
    document.addEventListener('keydown', function(e) {
        if (
            e.key === "F12" || 
            (e.ctrlKey && e.shiftKey && e.key === "I") || 
            (e.ctrlKey && e.shiftKey && e.key === "J") || 
            (e.ctrlKey && e.key === "U") || 
            (e.ctrlKey && e.shiftKey && e.key === "C")
        ) {
            e.preventDefault();
        }
    });
</script>
</body>
</html>
