<?php
// Función para obtener y procesar el contenido de una URL
function obtener_y_procesar_contenido($url) {
    // Obtener el contenido de la URL
    $contenido = file_get_contents($url);

    // Definir reemplazos de texto para las URLs relativas
    $reemplazos_texto = array(
        "../" => "https://www.thesportsdb.com/",
        "/images/icons/flags/" => "https://www.thesportsdb.com/images/icons/flags/",
        "/images/icons/calendar.png" => "https://www.thesportsdb.com/images/icons/calendar.png",
        "/images/icons/time.png" => "https://www.thesportsdb.com/images/icons/time.png"
    );

    // Reemplazar las URLs relativas por las absolutas
    $contenido = str_replace(array_keys($reemplazos_texto), array_values($reemplazos_texto), $contenido);
    // Añadir estilo a las imágenes para que tengan bordes redondeados
    $contenido = preg_replace('/(<img[^>]+)(>)/i', '$1 style="border-radius: 10px;"$2', $contenido);

    // Crear un objeto DOMDocument para manipular el HTML
    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML($contenido);
    libxml_use_internal_errors(false);

    // Usar XPath para buscar elementos <a> y eliminar el atributo href
    $xpath = new DOMXPath($dom);
    $elementos_enlace = $xpath->query('//a');
    foreach ($elementos_enlace as $elemento_enlace) {
        $elemento_enlace->removeAttribute('href');
    }

    // Buscar elementos <td> y añadirles estilos
    $elementos_td = $xpath->query('//td');
    foreach ($elementos_td as $elemento_td) {
        $elemento_td->setAttribute('style', 'text-align: left; vertical-align: top; width: 20%; color: white; text:bold 2px 2px 2px ;');
    }

    return $dom;
}

// URLs de las ligas deportivas
$url_premier_league = "https://www.thesportsdb.com/league/4328-English-Premier-League";
$url_english_league_championship = "https://www.thesportsdb.com/league/4329-English-League-Championship";
$url_nfl = "https://www.thesportsdb.com/league/4391-NFL";
$url_efl_trophy = "https://www.thesportsdb.com/league/4847-EFL-Trophy";
$url_efl_cup = "https://www.thesportsdb.com/league/4570-EFL-Cup";
$url_english_t20_blast = "https://www.thesportsdb.com/league/4463-English-t20-Blast";
$url_ipl = "https://www.thesportsdb.com/league/4460-Indian-Premier-League";

// Obtener y procesar el contenido de cada liga
$dom_premier_league = obtener_y_procesar_contenido($url_premier_league);
$dom_english_league_championship = obtener_y_procesar_contenido($url_english_league_championship);
$dom_nfl = obtener_y_procesar_contenido($url_nfl);
$dom_efl_trophy = obtener_y_procesar_contenido($url_efl_trophy);
$dom_efl_cup = obtener_y_procesar_contenido($url_efl_cup);
$dom_english_t20_blast = obtener_y_procesar_contenido($url_english_t20_blast);
$dom_ipl = obtener_y_procesar_contenido($url_ipl);

// Generar la página HTML
echo "<!DOCTYPE html>
<html>
<head>
    <title>Guía Deportiva: Premier League, English League Championship, NFL, EFL Trophy, EFL Cup, English T20 Blast, e IPL</title>
    <style>
        body {
            background-image: url('https://as2.ftcdn.net/v2/jpg/04/17/36/11/1000_F_417361125_RnrhT3Np0zB0UpeD7QlwuOoyghEGGjBX.jpg');
            background-size: cover;
            background-repeat: no-repeat;
            background-attachment: fixed;
            font-family: Arial, sans-serif;
            color: white;
        }
        .container {
            width: 97%;
            margin: auto;
            overflow: hidden;
            background-color: rgba(0, 0, 0, 0.7);
            padding: 20px;
            border-radius: 10px;
        }
        .event {
            background-color: #fff;
            margin: 10px 0;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            color: black;
        }
        .event h2 {
            margin: 0;
            color: #333;
        }
        .event p {
            margin: 5px 0;
            color: #666;
        }
        .scrolling {
            position: fixed;
            bottom: 0;
            width: 100%;
            background-color: #000;
            color: #fff;
            text-align: center;
            padding: 10px 0;
            font-size: 1.2em;
            cursor: pointer;
        }
        .scroll-buttons {
            position: fixed;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            display: flex;
            flex-direction: column;
        }
        .scroll-buttons button {
            background-color: rgba(255, 255, 255, 0.7);
            border: none;
            padding: 5px;
            margin: 2.5px;
            cursor: pointer;
            border-radius: 5px;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class='container'>
        <h1>Partidos y Resultados de la Premier League</h1>";

// Mostrar la tabla de la Premier League
$tabla_premier_league = $dom_premier_league->getElementsByTagName('table')->item(0);
if ($tabla_premier_league) {
    echo $dom_premier_league->saveHTML($tabla_premier_league);
} else {
    echo "<p>No se encontró la tabla de la Premier League.</p>";
}

echo "  <h1>Partidos y Resultados de la English League Championship</h1>";

$tabla_english_league_championship = $dom_english_league_championship->getElementsByTagName('table')->item(0);
if ($tabla_english_league_championship) {
    echo $dom_english_league_championship->saveHTML($tabla_english_league_championship);
} else {
    echo "<p>No se encontró la tabla de la English League Championship.</p>";
}

echo "  <h1>Partidos y Resultados de la NFL</h1>";

$tabla_nfl = $dom_nfl->getElementsByTagName('table')->item(0);
if ($tabla_nfl) {
    echo $dom_nfl->saveHTML($tabla_nfl);
} else {
    echo "<p>No se encontró la tabla de la NFL.</p>";
}

echo "  <h1>Partidos y Resultados del EFL Trophy</h1>";

$tabla_efl_trophy = $dom_efl_trophy->getElementsByTagName('table')->item(0);
if ($tabla_efl_trophy) {
    echo $dom_efl_trophy->saveHTML($tabla_efl_trophy);
} else {
    echo "<p>No se encontró la tabla del EFL Trophy.</p>";
}

echo "  <h1>Partidos y Resultados del EFL Cup</h1>";

$tabla_efl_cup = $dom_efl_cup->getElementsByTagName('table')->item(0);
if ($tabla_efl_cup) {
    echo $dom_efl_cup->saveHTML($tabla_efl_cup);
} else {
    echo "<p>No se encontró la tabla del EFL Cup.</p>";
}

echo "  <h1>Partidos y Resultados del English T20 Blast</h1>";

$tabla_english_t20_blast = $dom_english_t20_blast->getElementsByTagName('table')->item(0);
if ($tabla_english_t20_blast) {
    echo $dom_english_t20_blast->saveHTML($tabla_english_t20_blast);
} else {
    echo "<p>No se encontró la tabla del English T20 Blast.</p>";
}

echo "  <h1>Partidos y Resultados del Indian Premier League (IPL)</h1>";

$tabla_ipl = $dom_ipl->getElementsByTagName('table')->item(0);
if ($tabla_ipl) {
    echo $dom_ipl->saveHTML($tabla_ipl);
} else {
    echo "<p>No se encontró la tabla del IPL.</p>";
}

echo "  </div>
    <div class='scrolling' onclick='openTelegram()'>RGVIP REBRAND</div>
    <div class='scroll-buttons'>
        <button onclick='scrollUp()'>Subir</button>
        <button onclick='scrollDown()'>Bajar</button>
        <button onclick='speedUp()'>Acelerar</button>
        <button onclick='slowDown()'>Desacelerar</button>
        <button onclick='toggleAutoScroll()'>Alternar Auto Scroll</button>
    </div>
    <script>
    let scrollSpeed = 0.4; // Velocidad inicial del scroll
    let scrollTop = 0;
    let autoScroll = true;

    function scroll() {
        if (autoScroll) {
            scrollTop += scrollSpeed;

            if (scrollTop >= document.body.scrollHeight - window.innerHeight) {
                scrollTop = 0;
            }

            window.scrollTo(0, scrollTop);
        }
        requestAnimationFrame(scroll);
    }

    function scrollUp() {
        window.scrollBy(0, -50);
    }

    function scrollDown() {
        window.scrollBy(0, 50);
    }

    function speedUp() {
        scrollSpeed += 0.2;
    }

    function slowDown() {
        if (scrollSpeed > 0.2) {
            scrollSpeed -= 0.2;
        }
    }

    function toggleAutoScroll() {
        autoScroll = !autoScroll;
    }

    function openTelegram() {
        window.open('https://t.me/RebrandiptvVIP1', '_blank');
    }

    function checkScriptIntegrity() {
        const linkElement = document.querySelector('.scrolling');
        if (linkElement && linkElement.getAttribute('onclick') === 'openTelegram()') {
            console.log('Integridad del script verificada');
        } else {
            console.error('Integridad del script comprometida');
            // Detener la ejecución del script
            document.body.innerHTML = '<h1>Integridad del script comprometida. La página ya no funciona.</h1>';
        }
    }

    // Verificar la integridad del script al cargar la página
    window.addEventListener('load', () => {
        setTimeout(scroll, 1000);
        checkScriptIntegrity();
    });

    // Configuración de WebSocket
    const socket = new WebSocket('ws://localhost:8080');

    socket.addEventListener('message', function (event) {
        const message = event.data;

        if (message === 'stop') {
            autoScroll = false;
        } else if (message === 'start') {
            autoScroll = true;
        } else if (message === 'up') {
            scrollUp();
        } else if (message === 'down') {
            scrollDown();
        } else if (message === 'speedup') {
            speedUp();
        } else if (message === 'slowdown') {
            slowDown();
        }
    });

    socket.addEventListener('open', function (event) {
        console.log('Conectado al servidor WebSocket');
    });

    socket.addEventListener('close', function (event) {
        console.log('Desconectado del servidor WebSocket');
    });

    socket.addEventListener('error', function (event) {
        console.error('Error en WebSocket:', event);
    });
    </script>
</body>
</html>";
?>     