<?php
// Configuración robusta
set_time_limit(30);
ini_set('memory_limit', '128M');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// Función optimizada para conexión a SQLite
function connectSQLite($path) {
    $max_retries = 5;
    $retry_delay = 200000; // 0.2 segundos
    
    // Eliminar archivos temporales de bloqueo si existen
    $lock_files = ['.db.db-shm', '.db.db-wal', 'codes_rgvip.db-shm', 'codes_rgvip.db-wal'];
    foreach ($lock_files as $file) {
        if (file_exists('./api/'.$file) && is_writable('./api/'.$file)) {
            @unlink('./api/'.$file);
        }
    }

    for ($i = 0; $i < $max_retries; $i++) {
        try {
            $db = new SQLite3($path);
            $db->enableExceptions(true);
            $db->busyTimeout(30000); // 30 segundos
            
            // Configuración óptima para escritura
            $db->exec("PRAGMA journal_mode = WAL");
            $db->exec("PRAGMA synchronous = NORMAL");
            $db->exec("PRAGMA temp_store = MEMORY");
            
            return $db;
        } catch (Exception $e) {
            if (strpos($e->getMessage(), 'locked') !== false && $i < ($max_retries - 1)) {
                usleep($retry_delay * ($i + 1));
                continue;
            }
            // Si falla después de reintentos, mostrar formulario en modo lectura
            error_log("Error de conexión SQLite: " . $e->getMessage());
            return false;
        }
    }
}

// Conexión a bases de datos (con tolerancia a fallos)
$db = connectSQLite('./api/.db.db');
$codesDB = connectSQLite('./api/codes_rgvip.db');
if ($codesDB) {
    $codesDB->exec("CREATE TABLE IF NOT EXISTS activation_codes (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        code TEXT UNIQUE,
        mac_address TEXT,
        username TEXT,
        password TEXT,
        dns TEXT,
        title TEXT,
        expire_date TEXT,
        used INTEGER DEFAULT 0,
        created_at TEXT
    )");
}
include 'includes/header.php';

// Generar token CSRF
if (empty($_SESSION['token'])) {
    $_SESSION['token'] = bin2hex(random_bytes(32));
}

$mensaje = '';
$success = false;
$readonly_mode = !$db || !$codesDB; // Modo solo lectura si no hay conexión

if (!$readonly_mode && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['token'], $_POST['code'])) {
    // Validar token CSRF
    if (!hash_equals($_SESSION['token'], $_POST['token'])) {
        die('Token de seguridad inválido');
    }

    $code = trim($_POST['code']);
    
    if (empty($code)) {
        $mensaje = "❌ Por favor ingrese un código válido";
    } else {
        try {
            // Paso 1: Buscar código
            $stmt = $codesDB->prepare("SELECT * FROM activation_codes WHERE code = :code AND used = 0 LIMIT 1");
            $stmt->bindValue(':code', $code, SQLITE3_TEXT);
            $result = $stmt->execute();
            $data = $result->fetchArray(SQLITE3_ASSOC);
            $stmt->close();

            if ($data) {
                // Paso 2: Insertar datos (método directo como en tu código funcional)
                $query = sprintf(
                    "INSERT INTO ibo (mac_address, username, password, expire_date, url, title, created_at) 
                    VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s')",
                    SQLite3::escapeString(strtoupper($data['mac_address'])),
                    SQLite3::escapeString($data['username']),
                    SQLite3::escapeString($data['password']),
                    SQLite3::escapeString($data['expire_date']),
                    SQLite3::escapeString($data['dns']),
                    SQLite3::escapeString($data['title']),
                    SQLite3::escapeString(date('Y-m-d H:i:s'))
                );
                
                if ($db->exec($query)) {
                    // Paso 3: Marcar código como usado
                    $codesDB->exec("UPDATE activation_codes SET used = 1 WHERE code = '".SQLite3::escapeString($code)."'");
                    // ✅ Paso 4: Insertar también en la tabla subscription
    $subscriptionInsert = sprintf(
        "INSERT INTO subscription (mac_address, expire_date) 
         VALUES ('%s', '%s')",
        SQLite3::escapeString(strtoupper($data['mac_address'])),
        SQLite3::escapeString($data['expire_date'])
    );
    $db->exec($subscriptionInsert);
    
                    $mensaje = "✅ Activación exitosa para MAC: ".htmlspecialchars($data['mac_address']);
                    $success = true;
                } else {
                    throw new Exception("Error al insertar: ".$db->lastErrorMsg());
                }
            } else {
                $mensaje = "❌ Código inválido o ya utilizado";
            }
        } catch (Exception $e) {
            $mensaje = "❌ Error: ".htmlspecialchars($e->getMessage());
            error_log("Error en activación: ".$e->getMessage());
        }
    }
}
?>
<div class="container-fluid">
    <div class="mx-auto" style="max-width: 500px;">
        <h3 class="text-center title-outside-card mb-1">🔑 Activación de Servicio</h3>
        <div class="card border-left-primary shadow h-100 card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-color"><i class="fas fa-user"></i> Detalles</h6>
            </div>
            <div class="card-body">
            <?php if ($readonly_mode): ?>
                <div class="alert alert-warning">
                    <strong>Advertencia:</strong> El sistema está en modo solo lectura temporalmente. 
                    Los datos no se guardarán. Por favor intente nuevamente en unos minutos.
                </div>
            <?php endif; ?>

            <?php if ($mensaje): ?>
                <div class="alert <?= $success ? 'alert-success' : 'alert-danger' ?>">
                    <?= $mensaje ?>
                </div>
            <?php endif; ?>

            <form method="post">
                <input type="hidden" name="token" value="<?= htmlspecialchars($_SESSION['token']) ?>">
                <div class="form-group">
                    <label><strong>Código de Activación</strong></label>
                    <input type="text" name="code" class="form-control" required
                           placeholder="Ingrese su código" <?= $readonly_mode ? 'disabled' : '' ?>>
                </div>
                <button type="submit" class="btn btn-primary btn-block mt-3" <?= $readonly_mode ? 'disabled' : '' ?>>
                    <i class="fas fa-play-circle"></i> <?= $readonly_mode ? 'Sistema no disponible' : 'Activar Servicio' ?>
                </button>
            </form>
        </div>
    </div>
</div>

<?php
// Cierre seguro de conexiones
if ($db) $db->close();
if ($codesDB) $codesDB->close();
include 'includes/footer.php';
?>